﻿<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Wypłaty gotówkowe razem</title>
		<script runat="server">

            int lp = 0;
            static bool osobneListy = false;    
            static int emptyLines = 0;
            Hashtable pracownicy = new Hashtable();
		        		        
            void grid_BeforeRow(object sender, RowEventArgs args) {
                ArrayList lst = (ArrayList)pracownicy[args.Row];
                decimal razem = 0m;
                foreach (Wyplata w in lst) {
                    razem += w.Gotówka.Value;
                    WyplataUmowa wu = w as WyplataUmowa;
                    Umowa umw = wu == null ? null : wu.Umowa;
                    if (umw == null)
                        colTytułem.AddLine(w.Numer.NumerPelny);
                    else
                        colTytułem.AddLine(umw.Numer.NumerPelny);
                    colKwota.AddLine(w.Gotówka);
                }
                colRazem.EditValue = razem;
                for (int i = 0; i < emptyLines; i++)
                    colBottom.AddLine();
            }

            protected void dc_ContextLoad(object sender, EventArgs e) {
                Row[] rows;
                if (osobneListy)
                    rows = new Row[] { (ListaPlac)dc[typeof(ListaPlac)] };
                else
                    rows = (Row[])dc[typeof(Row[])];

                bool bufor = false;
                string listy = "";
                foreach (ListaPlac lista in rows) {
                    bufor |= lista.Bufor;

                    if (listy != "")
                        listy += "; ";
                    listy += "<b>" + lista.Numer.NumerPelny + "</b>";

                    foreach (Wyplata w in lista.Wyplaty)
                        if (w.Gotówka != 0) {
                            ArrayList lst = (ArrayList)pracownicy[w.Pracownik];
                            if (lst == null)
                                pracownicy.Add(w.Pracownik, lst = new ArrayList());
                            lst.Add(w);
                        }
                }

                if (bufor)
                    ReportHeader["BUFOR"] = "Lista nie została zatwierdzona!|";
                else
                    ReportHeader["BUFOR"] = "";

                Opis.EditValue = "<font size=\"2\">Listy płac: " + listy + "</font>";
                ArrayList praclst = new ArrayList(pracownicy.Keys);
                praclst.Sort();
                Grid.DataSource = praclst;

                if (emptyLines == 0) {
                    Grid.RowsInRow = 2;
                    colBottom.Visible = false;
                }
            }
		    
</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Wypłaty gotówkowe|%BUFOR%</strong>Typ: <strong>{0}|</strong>Okres: <strong>{1}" runat="server" DataMember1="ListyPlacViewInfo+Params.Okres" DataMember0="ListyPlacViewInfo+Params.Typ"></eb:ReportHeader>
            <ea:DataLabel ID="Opis" runat="server" Bold="False">
            </ea:DataLabel>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" OnBeforeRow="grid_BeforeRow" RowsInRow="3">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" Caption="LP." RowSpan="2" runat="server" BottomBorder="Single" DataMember="#"></ea:GridColumn>
                    <ea:GridColumn ID="colBottom" runat="server" ColSpan="5">
                    </ea:GridColumn>
					<ea:GridColumn DataMember="NazwiskoImię" Caption="Nazwisko i imię" runat="server" Format="&lt;b&gt;{0}&lt;/b&gt;"></ea:GridColumn>
					<ea:GridColumn DataMember="Last.PESEL" Caption="PESEL" runat="server" BottomBorder="Single" VAlign="Top"></ea:GridColumn>
                    <ea:GridColumn ID="colTytułem" runat="server" BottomBorder="Single" Caption="Tytułem"
                        RowSpan="2" Width="30" Total="Info" VAlign="Top">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colKwota" runat="server" Align="Right" BottomBorder="Single" Caption="Kwota"
                        Format="{0:n}" RowSpan="2" Width="16" Total="Sum" VAlign="Top">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colRazem" runat="server" Align="Right" Caption="Razem do wypłaty"
                        Format="&lt;strong&gt;{0:n}&lt;/strong&gt;" Width="16">
                    </ea:GridColumn>
					<ea:GridColumn Align="Center" Caption="Podpis" Format="&lt;br&gt;........................" runat="server" VAlign="Bottom" BottomBorder="Single"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server">
				<Subtitles>
					<eb:FooterSubtitle SubtitleType="Operator"></eb:FooterSubtitle>
					<eb:FooterSubtitle Caption="Sporządził"></eb:FooterSubtitle>
					<eb:FooterSubtitle Caption="Gł&#243;wny księgowy"></eb:FooterSubtitle>
					<eb:FooterSubtitle Caption="Kierownik jednostki"></eb:FooterSubtitle>
				</Subtitles>
			</eb:ReportFooter>
		</form>
	</body>
</HTML>
